/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalPattern;
import filenet.sim.api.VWScenarioArrivalType;
import filenet.sim.api.VWScenarioCollectionDefinition;
import filenet.sim.api.VWScenarioConfiguration;
import filenet.sim.api.VWScenarioDurationPattern;
import filenet.sim.api.VWScenarioFieldAssignments;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioTimeUnitType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXParseException;

public final class VWScenarioDefinition
implements Serializable,
Cloneable {
    private String m_description = null;
    private Object m_startTime = null;
    private Date m_absoluteStartTime = null;
    private Object m_endTime = null;
    private Date m_absoluteEndTime = null;
    private String m_name = null;
    private Integer m_seed = null;
    private int m_resourcePriority = 0;
    private boolean m_animationEnabled = false;
    private boolean m_collectAnalysisData = false;
    private List m_workflows = Collections.synchronizedList(new ArrayList());
    private Map m_roles = Collections.synchronizedMap(new HashMap());
    private Map m_shifts = Collections.synchronizedMap(new HashMap());
    private Map m_resources = Collections.synchronizedMap(new HashMap());
    private Map<String, CEObjectInfo> m_ceObjectList = Collections.synchronizedMap(new HashMap());
    private VWScenarioConfiguration m_configuration = null;
    private VWScenarioCollectionDefinition m_scenarioCollection = null;
    protected static final String SYSTEM_RESOURCE = "F_System";
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;

    public String getName() {
        return this.m_name;
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("sim.api.VWScenarioDefinition.NullNameParameter", "The name parameter cannot be null or empty.");
        }
        if (VWStringUtils.compare(this.m_name, theName) == 0) {
            return;
        }
        if (this.m_scenarioCollection != null) {
            this.m_scenarioCollection.updateScenarioNameInList(this.m_name, theName);
        }
        this.m_name = theName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String theDescription) {
        this.m_description = theDescription;
    }

    public Object getStartTime() {
        return this.m_startTime;
    }

    protected Date getAbsoluteStartTime() {
        return this.m_absoluteStartTime;
    }

    public void setStartTime(Object theStartTime) throws VWException {
        if (theStartTime != null && !VWScenarioTimeType.isValid(theStartTime)) {
            throw new VWException("sim.api.VWScenarioDefinitionInvalidTimeValue", "The value is a {0}, which is not a supported time type.", theStartTime.getClass().getName());
        }
        this.m_startTime = theStartTime;
    }

    public Object getEndTime() {
        return this.m_endTime;
    }

    protected Date getAbsoluteEndTime() {
        return this.m_absoluteEndTime;
    }

    public void setEndTime(Object theEndTime) throws VWException {
        if (theEndTime != null && !VWScenarioTimeType.isValid(theEndTime)) {
            throw new VWException("sim.api.VWScenarioDefinitionInvalidTimeValue", "The value is a {0}, which is not a supported time type.", theEndTime.getClass().getName());
        }
        this.m_endTime = theEndTime;
    }

    public Integer getSeed() {
        return this.m_seed;
    }

    public void setSeed(Integer seed) {
        this.m_seed = seed;
    }

    public int getResourcePriority() {
        return this.m_resourcePriority;
    }

    public void setResourcePriority(int priority) {
        this.m_resourcePriority = priority;
    }

    public boolean getAnimationEnabled() {
        return this.m_animationEnabled;
    }

    public void setAnimationEnabled(boolean enabled) {
        this.m_animationEnabled = enabled;
    }

    public boolean getCollectAnalyisData() {
        return this.m_collectAnalysisData;
    }

    public void setCollectAnalysisData(boolean collectData) {
        this.m_collectAnalysisData = collectData;
    }

    public VWScenarioResourceDefinition createResource(String name, int type, int quantity, double cost, float performance) throws VWException {
        if (name != null && name.equals(SYSTEM_RESOURCE)) {
            throw new VWException("sim.api.VWScenarioDefinition.ReservedResourceName", "The resource name {0} is reserved for interal use.", SYSTEM_RESOURCE);
        }
        if (this.m_resources.containsKey(name)) {
            throw new VWException("sim.api.VWScenarioDefinition.ResourceAlreadyExists", "A resource with the name {0} has already been created.", name);
        }
        VWScenarioResourceDefinition resource = new VWScenarioResourceDefinition(name, type, quantity, cost, performance, this);
        this.m_resources.put(name, resource);
        return resource;
    }

    public VWScenarioResourceDefinition createResource(String name, VWScenarioResourceDefinition resource) throws VWException {
        if (name != null && name.equals(SYSTEM_RESOURCE)) {
            throw new VWException("sim.api.VWScenarioDefinition.ReservedResourceName", "The resource name {0} is reserved for interal use.", SYSTEM_RESOURCE);
        }
        if (this.m_resources.containsKey(name)) {
            throw new VWException("sim.api.VWScenarioDefinition.ResourceAlreadyExists", "A resource with the name {0} has already been created.", name);
        }
        VWScenarioResourceDefinition clone = (VWScenarioResourceDefinition)resource.clone(name);
        this.m_resources.put(name, clone);
        return clone;
    }

    public VWScenarioResourceDefinition[] getResources() {
        if (this.m_resources.size() == 0) {
            return null;
        }
        return this.m_resources.values().toArray(new VWScenarioResourceDefinition[0]);
    }

    public VWScenarioResourceDefinition getResource(String resourceName) throws VWException {
        if (resourceName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullResourceNameParameter", "The resource name parameter can not be null.");
        }
        if (!this.m_resources.containsKey(resourceName)) {
            throw new VWException("sim.api.VWScenarioDefinition.ResourceNotFound", "Invalid resource name. A resource with the name {0} has not been defined for this scenario.", resourceName);
        }
        return (VWScenarioResourceDefinition)this.m_resources.get(resourceName);
    }

    public void deleteResource(String resourceName) throws VWException {
        if (resourceName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullResourceNameParameter", "The resource name parameter can not be null.");
        }
        if (!this.m_resources.containsKey(resourceName)) {
            throw new VWException("sim.api.VWScenarioDefinition.ResourceNotFound", "No resource found with name equal to {0} in scenario definition.", resourceName);
        }
        if (this.getResource(resourceName).hasResourceAssignments()) {
            throw new VWException("sim.api.VWScenarioDefinition.ResourceHasAssignments", "Resource {0} can''t be deleted without first deleting the associated resource assignment objects.", resourceName);
        }
        this.m_resources.remove(resourceName);
    }

    protected void updateResource(String oldName, String newName) throws VWException {
        VWScenarioResourceDefinition resource = (VWScenarioResourceDefinition)this.m_resources.remove(oldName);
        if (resource != null) {
            this.m_resources.put(newName, resource);
        }
    }

    protected boolean hasResource(String resourceName) throws VWException {
        return this.m_resources.containsKey(resourceName);
    }

    public VWScenarioRoleDefinition createRole(String roleName) throws VWException {
        if (this.m_roles.containsKey(roleName)) {
            throw new VWException("sim.api.VWScenarioDefinition.RoleAlreadyExists", "A role with the name {0} has already been created.", roleName);
        }
        VWScenarioRoleDefinition role = new VWScenarioRoleDefinition(roleName, this);
        this.m_roles.put(roleName, role);
        return role;
    }

    public VWScenarioRoleDefinition createRole(String roleName, VWScenarioRoleDefinition role) throws VWException {
        if (this.m_roles.containsKey(roleName)) {
            throw new VWException("sim.api.VWScenarioDefinition.RoleAlreadyExists", "A role with the name {0} has already been created.", roleName);
        }
        VWScenarioRoleDefinition clone = (VWScenarioRoleDefinition)role.clone(roleName);
        this.m_roles.put(roleName, clone);
        return clone;
    }

    public VWScenarioRoleDefinition[] getRoles() {
        if (this.m_roles.size() == 0) {
            return null;
        }
        return this.m_roles.values().toArray(new VWScenarioRoleDefinition[0]);
    }

    public VWScenarioRoleDefinition getRole(String roleName) throws VWException {
        if (roleName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullRoleNameParameter", "The roleName parameter can not be null.");
        }
        if (!this.m_roles.containsKey(roleName)) {
            throw new VWException("sim.api.VWScenarioDefinition.RoleNotFound", "No role found with name equal to {0} in scenario definition.", roleName);
        }
        return (VWScenarioRoleDefinition)this.m_roles.get(roleName);
    }

    public void deleteRole(String roleName) throws VWException {
        if (roleName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullRoleNameParameter", "The roleName parameter can not be null.");
        }
        if (!this.m_roles.containsKey(roleName)) {
            throw new VWException("sim.api.VWScenarioDefinition.RoleNotFound", "No role found with name equal to {0} in scenario definition.", roleName);
        }
        if (this.getRole(roleName).hasRoleAssignments()) {
            throw new VWException("sim.api.VWScenarioDefinition.RoleHasAssignments", "Role {0} can''t be deleted without first deleting the associated role assignment objects.", roleName);
        }
        this.m_roles.remove(roleName);
    }

    protected void updateRole(String oldName, String newName) throws VWException {
        VWScenarioRoleDefinition role = (VWScenarioRoleDefinition)this.m_roles.remove(oldName);
        if (role != null) {
            this.m_roles.put(newName, role);
        }
    }

    protected boolean hasRole(String roleName) throws VWException {
        return this.m_roles.containsKey(roleName);
    }

    public VWScenarioShiftDefinition createShift(String shiftName) throws VWException {
        if (this.m_shifts.containsKey(shiftName)) {
            throw new VWException("sim.api.VWScenarioDefinition.ShiftAlreadyExists", "A shift with the name {0} has already been created.", shiftName);
        }
        VWScenarioShiftDefinition shift = new VWScenarioShiftDefinition(shiftName, this);
        this.m_shifts.put(shiftName, shift);
        return shift;
    }

    public VWScenarioShiftDefinition createShift(String shiftName, VWScenarioShiftDefinition shift) throws VWException {
        if (this.m_shifts.containsKey(shiftName)) {
            throw new VWException("sim.api.VWScenarioDefinition.ShiftAlreadyExists", "A shift with the name {0} has already been created.", shiftName);
        }
        VWScenarioShiftDefinition clone = (VWScenarioShiftDefinition)shift.clone(shiftName);
        this.m_shifts.put(shiftName, clone);
        return clone;
    }

    public VWScenarioShiftDefinition[] getShifts() {
        if (this.m_shifts.size() == 0) {
            return null;
        }
        return this.m_shifts.values().toArray(new VWScenarioShiftDefinition[0]);
    }

    public VWScenarioShiftDefinition getShift(String shiftName) throws VWException {
        if (shiftName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullShiftNameParameter", "The shiftName parameter can not be null.");
        }
        if (!this.m_shifts.containsKey(shiftName)) {
            throw new VWException("sim.api.VWScenarioDefinition.ShiftNotFound", "No shift found with name equal to {0} in scenario definition.", shiftName);
        }
        return (VWScenarioShiftDefinition)this.m_shifts.get(shiftName);
    }

    public void deleteShift(String shiftName) throws VWException {
        if (shiftName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullShiftNameParameter", "The shiftName parameter can not be null.");
        }
        if (!this.m_shifts.containsKey(shiftName)) {
            throw new VWException("sim.api.VWScenarioDefinition.ShiftNotFound", "No shift found with name equal to {0} in scenario definition.", shiftName);
        }
        this.getShift(shiftName).releaseReferences();
        this.m_shifts.remove(shiftName);
    }

    protected void updateShift(String oldName, String newName) throws VWException {
        VWScenarioShiftDefinition shift = (VWScenarioShiftDefinition)this.m_shifts.remove(oldName);
        if (shift != null) {
            this.m_shifts.put(newName, shift);
        }
    }

    protected boolean hasShift(String shiftName) throws VWException {
        return this.m_shifts.containsKey(shiftName);
    }

    public VWScenarioWorkflowDefinition importWorkflow(VWWorkflowDefinition workflowDef, VWSession session) throws VWException {
        if (workflowDef == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullWorkflowDefParameter", "The workflowDef parameter can not be null.");
        }
        if (workflowDef.getName() == null) {
            throw new VWException("sim.api.VWScenarioDefinition.WorkflowDefNullName", "The workflow definition does not have a name defined and can not be imported.");
        }
        if (this.getWorkflowIndex(workflowDef.getName()) != -1) {
            throw new VWException("sim.api.VWScenarioDefinition.ProcessAlreadyExists", "A workflow definition with the name {0} has already been imported into the scenario.", workflowDef.getName());
        }
        VWScenarioWorkflowDefinition process = new VWScenarioWorkflowDefinition(workflowDef, this, session);
        this.m_workflows.add(process);
        return process;
    }

    public VWScenarioWorkflowDefinition importWorkflow(VWWorkflowDefinition workflowDef) throws VWException {
        return this.importWorkflow(workflowDef, null);
    }

    public VWScenarioWorkflowDefinition[] getWorkflows() {
        if (this.m_workflows.size() == 0) {
            return null;
        }
        return this.m_workflows.toArray(new VWScenarioWorkflowDefinition[0]);
    }

    public VWScenarioWorkflowDefinition getWorkflow(String workflowName) throws VWException {
        if (workflowName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullWorkflowNameParameter", "The workflowName parameter can not be null.");
        }
        int index = this.getWorkflowIndex(workflowName);
        if (index == -1) {
            throw new VWException("sim.api.VWScenarioDefinition.ProcessNotFound", "Workflow definition {0} has not been imported into this scenario.", workflowName);
        }
        return (VWScenarioWorkflowDefinition)this.m_workflows.get(index);
    }

    public void deleteWorkflow(String workflowName) throws VWException {
        if (workflowName == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullWorkflowNameParameter", "The workflowName parameter can not be null.");
        }
        int index = this.getWorkflowIndex(workflowName);
        if (index == -1) {
            throw new VWException("sim.api.VWScenarioDefinition.ProcessNotFound", "Workflow definition {0} has not been imported into this scenario.", workflowName);
        }
        this.m_workflows.remove(index);
    }

    protected boolean hasWorkflow(String workflowName) throws VWException {
        return this.getWorkflowIndex(workflowName) != -1;
    }

    public void addCEObjectInfo(CEObjectInfo ceObjectInfo) {
        if (ceObjectInfo != null) {
            this.m_ceObjectList.put(ceObjectInfo.getGuid(), ceObjectInfo);
        }
    }

    public CEObjectInfo createCEObjectInfo(String sId, String sName, String sSymbolicName) throws VWException {
        CEObjectInfo ceObjectInfo = new CEObjectInfo(sId, sName, sSymbolicName);
        this.m_ceObjectList.put(sId, ceObjectInfo);
        return ceObjectInfo;
    }

    public CEObjectInfo[] getCEObjectInfoObjects() {
        if (this.m_ceObjectList.size() == 0) {
            return null;
        }
        return this.m_ceObjectList.values().toArray(new CEObjectInfo[0]);
    }

    public CEObjectInfo getCEObjectInfo(String sId) throws VWException {
        if (sId == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullCEObjectInfoIdParameter", "The sId parameter can not be null.");
        }
        return this.m_ceObjectList.get(sId);
    }

    public static VWScenarioDefinition read(InputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullInputStream", "InputStream parameter is null.");
        }
        VWScenarioDefinition scenario = null;
        try {
            InputStreamReader isr = new InputStreamReader(theStream, "UTF8");
            BufferedReader in = new BufferedReader(isr);
            scenario = VWScenarioDefinition.read(in);
        }
        catch (UnsupportedEncodingException e) {
            throw new VWException("sim.api.VWScenarioDefinition.XMLReadError", " Exception reading XML, {0}.", e.getMessage());
        }
        return scenario;
    }

    public static VWScenarioDefinition read(String xmlString) throws VWException {
        if (xmlString == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullStreamReader", "xmlString parameter is null.");
        }
        return VWScenarioDefinition.read(new BufferedReader(new StringReader(xmlString)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static VWScenarioDefinition read(BufferedReader in) throws VWException {
        VWScenarioDefinition scenario = null;
        try {
            try {
                scenario = VWScenarioXMLHandler.parseXMLScenario(in, true);
            }
            catch (SAXParseException err) {
                String errString = "** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getMessage();
                throw new VWException("sim.api.VWScenarioDefinition.XMLReadParse", "XML Parsing error {0}.", errString);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new VWException("sim.api.VWScenarioDefinition.XMLReadError", " Exception reading XML, {0}.", e.getMessage());
            }
            Object var5_2 = null;
            if (in == null) return scenario;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        in.close();
        return scenario;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VWScenarioDefinition readFromFile(String theFileName) throws VWException {
        VWScenarioDefinition vWScenarioDefinition;
        FileInputStream istream = null;
        try {
            try {
                istream = new FileInputStream(theFileName);
                vWScenarioDefinition = VWScenarioDefinition.read(istream);
                Object var5_4 = null;
                if (istream == null) return vWScenarioDefinition;
            }
            catch (Exception e) {
                if (istream == null) throw new VWException("sim.api.VWScenarioDefinition.XMLReadFromFileError", " Exception reading XML from file, {0}.", e.getMessage());
                try {
                    ((InputStream)istream).close();
                    throw new VWException("sim.api.VWScenarioDefinition.XMLReadFromFileError", " Exception reading XML from file, {0}.", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new VWException("sim.api.VWScenarioDefinition.XMLReadFromFileError", " Exception reading XML from file, {0}.", e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (istream == null) throw throwable;
            try {
                ((InputStream)istream).close();
                throw throwable;
            }
            catch (Exception E) {
                throw throwable;
            }
        }
        try {}
        catch (Exception E) {
            // empty catch block
            return vWScenarioDefinition;
        }
        ((InputStream)istream).close();
        return vWScenarioDefinition;
    }

    public void write(OutputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullStream", "output stream parameter is null");
        }
        StringBuffer scenarioXML = new StringBuffer();
        this.toXML(scenarioXML);
        try {
            OutputStreamWriter out = new OutputStreamWriter(theStream, "UTF8");
            out.write(scenarioXML.toString());
            ((Writer)out).flush();
        }
        catch (Exception e) {
            throw new VWException("sim.api.VWScenarioDefinition.XMLWriteError", " Exception writing XML, {0}.", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeToFile(String theFileName) throws VWException {
        FileOutputStream ostream = null;
        try {
            try {
                ostream = new FileOutputStream(theFileName);
                this.write(ostream);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (ostream == null) throw new VWException("sim.api.VWScenarioDefinition.XMLWriteToFileError", " Exception writing XML to file, {0}.", e.getMessage());
                try {
                    ((OutputStream)ostream).close();
                    throw new VWException("sim.api.VWScenarioDefinition.XMLWriteToFileError", " Exception writing XML to file, {0}.", e.getMessage());
                }
                catch (Exception E) {
                    // empty catch block
                }
                throw new VWException("sim.api.VWScenarioDefinition.XMLWriteToFileError", " Exception writing XML to file, {0}.", e.getMessage());
            }
            Object var6_3 = null;
            if (ostream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (ostream == null) throw throwable;
            try {
                ((OutputStream)ostream).close();
                throw throwable;
            }
            catch (Exception E) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception E) {}
        ((OutputStream)ostream).close();
        return;
    }

    public VWScenarioConfiguration getConfiguration() {
        return this.m_configuration;
    }

    protected void setConfiguration(VWScenarioConfiguration config) {
        this.m_configuration = config;
    }

    protected void setScenarioCollection(VWScenarioCollectionDefinition scenarioCollectionDefinition) {
        this.m_scenarioCollection = scenarioCollectionDefinition;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(null, null, theBuffer);
    }

    protected void toXPDL_withNoXMLDeclaration(StringBuffer theBuffer) throws VWException {
        if (theBuffer == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullBufferParameter", "Parameter theBuffer cannot be null.");
        }
        String ATTRIB_INDENT = "\t";
        theBuffer.append("<Scenario ApiVersion=\"1.0\"\n");
        theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWScenarioXMLHandler.toXMLString(this.getDescription()) + "\"");
        theBuffer.append(">\n");
        this.getWorkflowXPDL(theBuffer);
        this.getConfigXML(theBuffer, null, null);
        this.getResourceXML(theBuffer, false);
        this.getArrivalXML(theBuffer, false);
        this.getActivityXML(theBuffer, false, true);
        this.getOptionsXML(theBuffer);
        this.getCEObjectInfoObjectsXML(theBuffer);
        theBuffer.append("</Scenario>\n");
    }

    public void toRuntimeXML(VWSession theSession, StringBuffer theBuffer) throws VWException {
        this.toRuntimeXML(theSession, null, theBuffer);
    }

    public void toRuntimeXML(VWSession theSession, VWSystemConfiguration sysConfig, StringBuffer theBuffer) throws VWException {
        if (theSession == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullSessionParameter", "Parameter theSession cannot be null.");
        }
        VWScenarioXMLHandler.generateRuntimeWorkflows(this, theSession);
        this.toXML(theSession, sysConfig, theBuffer);
    }

    private void toXML(VWSession theSession, VWSystemConfiguration sysConfig, StringBuffer theBuffer) throws VWException {
        if (theBuffer == null) {
            throw new VWException("sim.api.VWScenarioDefinition.NullBufferParameter", "Parameter theBuffer cannot be null.");
        }
        String ATTRIB_INDENT = "\t";
        theBuffer.append("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE Scenario SYSTEM \"scenario2.dtd\">\n<Scenario ApiVersion=\"1.0\"\n");
        theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWScenarioXMLHandler.toXMLString(this.getDescription()) + "\"");
        if (theSession != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "System=\"" + VWScenarioXMLHandler.toXMLString(theSession.getServerName()) + "\"");
            theBuffer.append("\n" + ATTRIB_INDENT + "Region=\"" + theSession.getIsolatedRegion() + "\"");
        }
        theBuffer.append(">\n");
        this.getWorkflowXML(theBuffer, theSession != null);
        this.getConfigXML(theBuffer, theSession, sysConfig);
        this.getResourceXML(theBuffer, theSession != null);
        this.getArrivalXML(theBuffer, theSession != null);
        this.getActivityXML(theBuffer, theSession != null, false);
        this.getOptionsXML(theBuffer);
        this.getCEObjectInfoObjectsXML(theBuffer);
        theBuffer.append("</Scenario>\n");
    }

    protected void getResourceXML(StringBuffer buffer, boolean runtime) throws VWException {
        Iterator i;
        String LEVEL_1_INDENT = "\t\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        String LEVEL_3_INDENT = LEVEL_2_INDENT + "\t";
        String LEVEL_4_INDENT = LEVEL_3_INDENT + "\t";
        buffer.append("\t<ResourceDefinition>\n");
        if (this.m_resources.size() > 0) {
            buffer.append(LEVEL_1_INDENT + "<Resources>\n");
            i = this.m_resources.values().iterator();
            while (i.hasNext()) {
                ((VWScenarioResourceDefinition)i.next()).toXML(buffer, LEVEL_2_INDENT);
            }
            if (!runtime) {
                StringBuffer roleXML = new StringBuffer();
                StringBuffer shiftXML = new StringBuffer();
                HashMap shifts = new HashMap();
                int index = 1;
                for (VWScenarioShiftDefinition shift : this.m_shifts.values()) {
                    String shiftName = shift.getName();
                    VWScenarioRoleAssignment[] roleAssignments = shift.getRoleAssignments();
                    if (roleAssignments == null) continue;
                    for (int j = 0; j < roleAssignments.length; ++j) {
                        if (roleAssignments[j].getResourceAssignments() != null) continue;
                        roleXML.append(LEVEL_4_INDENT + "<RoleAssignment ");
                        roleXML.append("Role=\"" + VWScenarioXMLHandler.toXMLString(roleAssignments[j].getRoleName()) + "\" ");
                        roleXML.append("Index=\"" + index + "\" ");
                        roleXML.append("Shift=\"" + VWScenarioXMLHandler.toXMLString(shiftName) + "\" ");
                        roleXML.append("Performance=\"1\"/>\n");
                        if (!shifts.containsKey(shiftName)) {
                            shifts.put(shiftName, null);
                            shiftXML.append(LEVEL_4_INDENT + "<ShiftAssignment Shift=\"" + VWScenarioXMLHandler.toXMLString(shiftName) + "\"/>\n");
                        }
                        ++index;
                    }
                }
                if (roleXML.length() > 0) {
                    buffer.append(LEVEL_2_INDENT + "<Resource ");
                    buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(SYSTEM_RESOURCE) + "\" ");
                    buffer.append("DisplayName=\"" + VWScenarioXMLHandler.toXMLString(SYSTEM_RESOURCE) + "\" ");
                    buffer.append("Type=\"" + VWScenarioXMLHandler.toXMLString("SYSTEM") + "\" ");
                    buffer.append("Quantity=\"1\" ");
                    buffer.append("Cost=\"0\" ");
                    buffer.append("Performance=\"1\">\n");
                    buffer.append(LEVEL_3_INDENT + "<RoleAssignments>\n");
                    buffer.append(roleXML.toString());
                    buffer.append(LEVEL_3_INDENT + "</RoleAssignments>\n");
                    buffer.append(LEVEL_3_INDENT + "<ShiftAssignments>\n");
                    buffer.append(shiftXML.toString());
                    buffer.append(LEVEL_3_INDENT + "</ShiftAssignments>\n");
                    buffer.append(LEVEL_2_INDENT + "</Resource>\n");
                }
            }
            buffer.append(LEVEL_1_INDENT + "</Resources>\n");
        }
        if (this.m_roles.size() > 0) {
            buffer.append(LEVEL_1_INDENT + "<Roles>\n");
            i = this.m_roles.values().iterator();
            while (i.hasNext()) {
                ((VWScenarioRoleDefinition)i.next()).toXML(buffer, LEVEL_2_INDENT);
            }
            buffer.append(LEVEL_1_INDENT + "</Roles>\n");
        }
        if (this.m_shifts.size() > 0) {
            buffer.append(LEVEL_1_INDENT + "<Shifts>\n");
            i = this.m_shifts.values().iterator();
            while (i.hasNext()) {
                ((VWScenarioShiftDefinition)i.next()).toXML(buffer, LEVEL_2_INDENT);
            }
            buffer.append(LEVEL_1_INDENT + "</Shifts>\n");
        }
        buffer.append("\t</ResourceDefinition>\n");
    }

    protected void getActivityXML(StringBuffer buffer, boolean runtime, boolean bIsXPDL) throws VWException {
        String LEVEL_1_INDENT = "\t\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        String LEVEL_3_INDENT = LEVEL_2_INDENT + "\t";
        String LEVEL_4_INDENT = LEVEL_3_INDENT + "\t";
        String LEVEL_5_INDENT = LEVEL_4_INDENT + "\t";
        buffer.append("\t<ActivityDefinition>\n");
        VWScenarioWorkflowDefinition[] scenarioWFs = this.getWorkflows();
        VWWorkflowDefinition workflowDef = null;
        VWScenarioStepSettings stepSettings = null;
        VWMapDefinition[] maps = null;
        VWMapNode[] steps = null;
        VWRouteDefinition[] routes = null;
        String mapName = null;
        if (scenarioWFs != null) {
            for (int i = 0; i < scenarioWFs.length; ++i) {
                workflowDef = scenarioWFs[i].getWorkflowDefinition(runtime);
                buffer.append(LEVEL_1_INDENT + "<ProcessRef ");
                buffer.append("Name=\"" + workflowDef.getName() + "\" ");
                buffer.append("Identifier=\"" + VWScenarioXMLHandler.toXMLString(workflowDef.getRuntimeId() != null ? workflowDef.getRuntimeId().toString() : "") + "\">\n");
                maps = workflowDef.getMaps();
                for (int j = 0; j < maps.length; ++j) {
                    mapName = maps[j].getName();
                    buffer.append(LEVEL_2_INDENT + "<MapRef ");
                    buffer.append("Name=\"" + mapName + "\" ");
                    buffer.append("Identifier=\"" + maps[j].getMapId() + "\">\n");
                    steps = maps[j].getSteps();
                    if (steps != null) {
                        for (int k = 0; k < steps.length; ++k) {
                            VWScenarioFieldAssignments fAssignments;
                            int stepId = steps[k].getStepId();
                            stepSettings = scenarioWFs[i].getStepSettings(mapName, stepId);
                            boolean keepResource = stepSettings.getKeepResource();
                            buffer.append(LEVEL_3_INDENT + "<ActivityRef ");
                            buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(steps[k].getName()) + "\" ");
                            buffer.append("Identifier=\"" + stepId + "\" ");
                            buffer.append("KeepResource=\"" + (keepResource ? "TRUE" : "FALSE") + "\" ");
                            buffer.append(">\n");
                            if (stepSettings.getDuration() != null) {
                                if (bIsXPDL) {
                                    buffer.append(LEVEL_4_INDENT + "<fn:Duration ");
                                } else {
                                    buffer.append(LEVEL_4_INDENT + "<Duration ");
                                }
                                buffer.append("Value=\"" + VWScenarioXMLHandler.toXMLString(stepSettings.getDuration().getDuration()) + "\" ");
                                buffer.append("Units=\"" + VWScenarioTimeUnitType.typeToString(stepSettings.getDuration().getUnits()) + "\" ");
                                buffer.append("/>\n");
                            }
                            if (stepSettings.getPeriodDuration() != null) {
                                buffer.append(LEVEL_4_INDENT + "<Period ");
                                buffer.append("Value=\"" + VWScenarioXMLHandler.toXMLString(stepSettings.getPeriodDuration().getDuration()) + "\" ");
                                buffer.append("Units=\"" + VWScenarioTimeUnitType.typeToString(stepSettings.getPeriodDuration().getUnits()) + "\" ");
                                buffer.append("/>\n");
                            }
                            if (stepSettings.getPauseDuration() != null) {
                                buffer.append(LEVEL_4_INDENT + "<Pause ");
                                buffer.append("Value=\"" + VWScenarioXMLHandler.toXMLString(stepSettings.getPauseDuration().getDuration()) + "\" ");
                                buffer.append("Units=\"" + VWScenarioTimeUnitType.typeToString(stepSettings.getPauseDuration().getUnits()) + "\" ");
                                buffer.append("/>\n");
                            }
                            if ((fAssignments = stepSettings.getFieldAssignments()) != null) {
                                fAssignments.toXML(buffer, LEVEL_4_INDENT);
                            }
                            if (stepSettings.getRoutingType() == 2 && (routes = steps[k].getNextRoutes()) != null) {
                                buffer.append(LEVEL_4_INDENT + "<Weights>\n");
                                for (int m = 0; m < routes.length; ++m) {
                                    buffer.append(LEVEL_5_INDENT + "<Weight ");
                                    buffer.append("Route=\"" + (m + 1) + "\" ");
                                    buffer.append("Weight=\"" + stepSettings.getRouteWeight(routes[m].getRouteId()) + "\"/>\n");
                                }
                                buffer.append(LEVEL_4_INDENT + "</Weights>\n");
                            }
                            buffer.append(LEVEL_3_INDENT + "</ActivityRef>\n");
                        }
                    }
                    buffer.append(LEVEL_2_INDENT + "</MapRef>\n");
                }
                VWScenarioDurationPattern dPattern = scenarioWFs[i].getDurationPattern();
                if (dPattern != null) {
                    buffer.append(LEVEL_2_INDENT + "<DurationAcquireItem ");
                    buffer.append("AdjustFactor=\"" + dPattern.getAdjustFactor() + "\" ");
                    if (dPattern.getDataSource() != null) {
                        buffer.append("DataSource=\"" + dPattern.getDataSource() + "\" ");
                    }
                    buffer.append(">\n");
                    buffer.append(LEVEL_3_INDENT + "<DurationStartTime>\n");
                    VWScenarioTimeType.timeValueToXML(dPattern.getAcquireStartTime(), "Act", buffer, LEVEL_3_INDENT);
                    buffer.append(LEVEL_3_INDENT + "</DurationStartTime>\n");
                    buffer.append(LEVEL_3_INDENT + "<DurationEndTime>\n");
                    VWScenarioTimeType.timeValueToXML(dPattern.getAcquireEndTime(), "Act", buffer, LEVEL_3_INDENT);
                    buffer.append(LEVEL_3_INDENT + "</DurationEndTime>\n");
                    buffer.append(LEVEL_2_INDENT + "</DurationAcquireItem>\n");
                }
                buffer.append(LEVEL_1_INDENT + "</ProcessRef>\n");
            }
        }
        buffer.append("\t</ActivityDefinition>\n");
    }

    protected void getArrivalXML(StringBuffer buffer, boolean runtime) throws VWException {
        String LEVEL_1_INDENT = "\t\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        StringBuffer arrivalsXML = new StringBuffer();
        StringBuffer aquireItemsXML = new StringBuffer();
        VWScenarioWorkflowDefinition[] scenarioWFs = this.getWorkflows();
        boolean bHasArrivalItems = false;
        boolean bHasAquireItems = false;
        if (scenarioWFs != null) {
            for (int i = 0; i < scenarioWFs.length; ++i) {
                Object[] arrivals = scenarioWFs[i].getArrivals(3);
                if (arrivals == null) continue;
                for (int j = 0; j < arrivals.length; ++j) {
                    int arrivalType = VWScenarioArrivalType.getArrivalType(arrivals[j]);
                    if (arrivalType == 1) {
                        if (!bHasArrivalItems) {
                            arrivalsXML.append(LEVEL_1_INDENT + "<Arrivals>\n");
                            bHasArrivalItems = true;
                        }
                        ((VWScenarioArrivalDefinition)arrivals[j]).toXML(arrivalsXML, LEVEL_2_INDENT, runtime);
                        continue;
                    }
                    if (arrivalType != 2) continue;
                    if (!bHasAquireItems) {
                        aquireItemsXML.append(LEVEL_1_INDENT + "<AcquireItems>\n");
                        bHasAquireItems = true;
                    }
                    ((VWScenarioArrivalPattern)arrivals[j]).toXML(aquireItemsXML, LEVEL_2_INDENT, runtime);
                }
            }
        }
        buffer.append("\t<ArrivalDefinition>\n");
        if (bHasArrivalItems) {
            arrivalsXML.append(LEVEL_1_INDENT + "</Arrivals>\n");
            buffer.append(arrivalsXML.toString());
        }
        if (bHasAquireItems) {
            aquireItemsXML.append(LEVEL_1_INDENT + "</AcquireItems>\n");
            buffer.append(aquireItemsXML.toString());
        }
        buffer.append("\t</ArrivalDefinition>\n");
    }

    protected void getWorkflowXML(StringBuffer buffer, boolean runtime) throws VWException {
        buffer.append("\t<WorkFlowDefinitions>\n");
        VWScenarioWorkflowDefinition[] scenarioWFs = this.getWorkflows();
        if (scenarioWFs != null) {
            String workflowXML = null;
            for (int i = 0; i < scenarioWFs.length; ++i) {
                workflowXML = scenarioWFs[i].getWorkflowDefinition(runtime).AsXMLString();
                if (workflowXML.startsWith("<?xml")) {
                    workflowXML = workflowXML.substring(workflowXML.indexOf(">") + 1);
                }
                if (workflowXML.startsWith("<!DOCTYPE") || workflowXML.startsWith("\n<!DOCTYPE")) {
                    workflowXML = workflowXML.substring(workflowXML.indexOf(">") + 1);
                }
                StringTokenizer tokens = new StringTokenizer(workflowXML, "\n", false);
                while (tokens.hasMoreTokens()) {
                    buffer.append("\t\t");
                    buffer.append(tokens.nextToken() + "\n");
                }
            }
        }
        buffer.append("\t</WorkFlowDefinitions>\n");
    }

    protected void getWorkflowXPDL(StringBuffer buffer) throws VWException {
        buffer.append("\t<WorkflowProcesses>\n");
        String indentA = "\t\t";
        VWScenarioWorkflowDefinition[] scenarioWFs = this.getWorkflows();
        if (scenarioWFs != null) {
            VWWorkflowCollectionDefinition wflCollDef = new VWWorkflowCollectionDefinition();
            for (int i = 0; i < scenarioWFs.length; ++i) {
                VWWorkflowDefinition wflDef = scenarioWFs[i].getWorkflowDefinition(false);
                if (wflDef == null) continue;
                wflCollDef.addWorkflow(wflDef);
                wflDef.toXPDL(indentA, buffer);
            }
        }
        buffer.append("\t</WorkflowProcesses>\n");
    }

    protected void getOptionsXML(StringBuffer buffer) throws VWException {
        String LEVEL_1_INDENT = "\t\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        buffer.append("\t<Options>\n");
        if (this.m_startTime == null) {
            buffer.append(LEVEL_1_INDENT + "<Begin Type=\"NOW\"/>\n");
        } else {
            buffer.append(LEVEL_1_INDENT + "<Begin ");
            buffer.append("Type=\"SPECIFIED\">\n");
            VWScenarioTimeType.timeValueToXML(this.m_startTime, buffer, LEVEL_2_INDENT);
            buffer.append(LEVEL_1_INDENT + "</Begin>\n");
        }
        if (this.m_endTime == null) {
            buffer.append(LEVEL_1_INDENT + "<End Type=\"NONE\"/>\n");
        } else {
            buffer.append(LEVEL_1_INDENT + "<End ");
            buffer.append("Type=\"SPECIFIED\">\n");
            VWScenarioTimeType.timeValueToXML(this.m_endTime, buffer, LEVEL_2_INDENT);
            buffer.append(LEVEL_1_INDENT + "</End>\n");
        }
        buffer.append(LEVEL_1_INDENT + "<Seed ");
        if (this.m_seed == null) {
            buffer.append("Type=\"SYSTEMTIME\"/>\n");
        } else {
            buffer.append("Type=\"SPECIFIED\" ");
            buffer.append("Value=\"" + this.m_seed + "\"/>\n");
        }
        buffer.append(LEVEL_1_INDENT + "<Animate ");
        if (this.m_animationEnabled) {
            buffer.append("Value=\"ON\"/>\n");
        } else {
            buffer.append("Value=\"OFF\"/>\n");
        }
        buffer.append(LEVEL_1_INDENT + "<Publish ");
        if (this.m_collectAnalysisData) {
            buffer.append("Value=\"DB\"/>\n");
        } else {
            buffer.append("Value=\"OFF\"/>\n");
        }
        buffer.append(LEVEL_1_INDENT + "<ResourcePriority ");
        switch (this.m_resourcePriority) {
            case 0: {
                buffer.append("Value=\"NONE\"/>\n");
                break;
            }
            case 1: {
                buffer.append("Value=\"FIFO\"/>\n");
                break;
            }
            case 2: {
                buffer.append("Value=\"PERFORMANCE\"/>\n");
            }
        }
        buffer.append(LEVEL_1_INDENT + "<LogFields Value=\"SELECTED\">\n");
        buffer.append(LEVEL_2_INDENT + "<LogField Name=\"S_Cost\"/>\n");
        buffer.append(LEVEL_2_INDENT + "<LogField Name=\"S_AccCost\"/>\n");
        buffer.append(LEVEL_1_INDENT + "</LogFields>\n");
        buffer.append(LEVEL_1_INDENT + "<Cubes Value=\"SELECTED\">\n");
        buffer.append(LEVEL_2_INDENT + "<Cube Name=\"WIP\"/>\n");
        buffer.append(LEVEL_2_INDENT + "<Cube Name=\"WORKFLOWWIP\"/>\n");
        buffer.append(LEVEL_2_INDENT + "<Cube Name=\"QUEUELOAD\"/>\n");
        buffer.append(LEVEL_2_INDENT + "<Cube Name=\"PRODUCTIVITY\"/>\n");
        buffer.append(LEVEL_2_INDENT + "<Cube Name=\"WORKLOAD\"/>\n");
        buffer.append(LEVEL_2_INDENT + "<Cube Name=\"CYCLETIME\"/>\n");
        buffer.append(LEVEL_1_INDENT + "</Cubes>\n");
        buffer.append("\t</Options>\n");
    }

    protected void getConfigXML(StringBuffer buffer, VWSession session, VWSystemConfiguration sysConfig) throws VWException {
        VWScenarioConfiguration scenarioConfig = null;
        scenarioConfig = session != null ? new VWScenarioConfiguration(session, sysConfig) : this.getConfiguration();
        if (scenarioConfig != null) {
            scenarioConfig.toXML(buffer, "\t");
        }
    }

    protected void getCEObjectInfoObjectsXML(StringBuffer buffer) throws VWException {
        CEObjectInfo[] ceObjectInfoList = this.getCEObjectInfoObjects();
        if (ceObjectInfoList == null || ceObjectInfoList.length == 0) {
            return;
        }
        String LEVEL_1_INDENT = "\t\t";
        buffer.append("\t<CEObjectInfoObjects>\n");
        for (int i = 0; i < ceObjectInfoList.length; ++i) {
            ceObjectInfoList[i].toXML(LEVEL_1_INDENT, buffer);
        }
        buffer.append("\t</CEObjectInfoObjects>\n");
    }

    public VWScenarioValidationError[] validate(VWSession theSession, boolean validateWorkflows, boolean fixupSteps) throws VWException {
        return this.validate(theSession, validateWorkflows, null, null);
    }

    public VWScenarioValidationError[] validate(VWSession theSession, boolean validateWorkflows, VWSystemConfiguration sysConfig, String sdfFileContents) throws VWException {
        VWScenarioShiftDefinition[] shifts;
        VWScenarioValidationError theError;
        int i;
        VWScenarioWorkflowDefinition[] swfs;
        VWScenarioValidationError theError2;
        VWString theMessage;
        Vector<VWScenarioValidationError> EDefVector = new Vector<VWScenarioValidationError>();
        Object[] theErrors = null;
        if (this.m_name == null || this.m_name.length() == 0) {
            theMessage = new VWString("sim.api.VWScenarioDefinition.NullOrEmptyName", "The name of the scenario definition is null or empty.");
            theError2 = new VWScenarioValidationError(2, 1, null, null, theMessage.toString());
            EDefVector.addElement(theError2);
        }
        if (this.m_startTime != null) {
            VWScenarioTimeType.validate(this.m_startTime, new Date(), 2, this.getName(), null, null, EDefVector);
            this.m_absoluteStartTime = VWScenarioTimeType.getAbsoluteTime(this.m_startTime);
        } else {
            this.m_absoluteStartTime = new Date();
        }
        if (this.m_endTime != null) {
            VWScenarioTimeType.validate(this.m_endTime, this.m_absoluteStartTime, 2, this.getName(), null, null, EDefVector);
            this.m_absoluteEndTime = VWScenarioTimeType.getAbsoluteTime(this.m_endTime);
            if (this.m_absoluteStartTime != null && this.m_absoluteEndTime != null && this.m_absoluteEndTime.compareTo(this.m_absoluteStartTime) <= 0) {
                theMessage = new VWString("sim.api.VWScenarioDefinition.EndTimeOutOfRange", "The sceanrio end date must be greater than the start date.");
                theError2 = new VWScenarioValidationError(2, 1, this.getName(), null, theMessage.toString());
                EDefVector.addElement(theError2);
            }
        } else {
            this.m_absoluteEndTime = null;
        }
        if ((swfs = this.getWorkflows()) != null) {
            boolean hasArrival = false;
            for (i = 0; i < swfs.length; ++i) {
                swfs[i].validate(EDefVector, theSession, validateWorkflows, sysConfig, sdfFileContents);
                if (!swfs[i].hasArrivals()) continue;
                hasArrival = true;
            }
            if (!hasArrival) {
                VWString theMessage2 = new VWString("sim.api.VWScenarioDefinition.NoWorkflowArrivals", "Scenario does not have any workflow arrivals defined.");
                theError = new VWScenarioValidationError(2, 1, this.getName(), null, theMessage2.toString());
                EDefVector.addElement(theError);
            }
        } else {
            VWString theMessage3 = new VWString("sim.api.VWScenarioDefinition.NoWorkflowsImported", "At least one workflow must be imported into the scenario.");
            VWScenarioValidationError theError3 = new VWScenarioValidationError(2, 1, this.getName(), null, theMessage3.toString());
            EDefVector.addElement(theError3);
        }
        VWScenarioResourceDefinition[] resources = this.getResources();
        if (resources != null) {
            for (i = 0; i < resources.length; ++i) {
                resources[i].validate(EDefVector);
            }
        } else {
            VWString theMessage4 = new VWString("sim.api.VWScenarioDefinition.NoResourcesAdded", "At least one resource must be added to the scenario.");
            theError = new VWScenarioValidationError(2, 1, this.getName(), null, theMessage4.toString());
            EDefVector.addElement(theError);
        }
        VWScenarioRoleDefinition[] roles = this.getRoles();
        if (roles != null) {
            if (sysConfig == null && theSession != null) {
                sysConfig = theSession.fetchSystemConfiguration();
            }
            for (int i2 = 0; i2 < roles.length; ++i2) {
                roles[i2].validate(EDefVector, sysConfig);
            }
        }
        if ((shifts = this.getShifts()) != null) {
            for (int i3 = 0; i3 < shifts.length; ++i3) {
                shifts[i3].validate(EDefVector);
            }
        }
        if (EDefVector.size() > 0) {
            theErrors = new VWScenarioValidationError[EDefVector.size()];
            EDefVector.copyInto(theErrors);
        }
        return theErrors;
    }

    public String toString() {
        return this.getName();
    }

    private int getWorkflowIndex(String workflowName) {
        int index = -1;
        int counter = 0;
        ListIterator iterator = this.m_workflows.listIterator();
        while (iterator.hasNext()) {
            if (((VWScenarioWorkflowDefinition)iterator.next()).getWorkflowDefinition().getName().equals(workflowName)) {
                index = counter;
                break;
            }
            ++counter;
        }
        return index;
    }

    protected static boolean isCompatibleType(int leftType, int rightType) throws VWException {
        if (!VWFieldType.isValid(leftType) || !VWFieldType.isValid(rightType)) {
            throw new VWException("sim.api.VWFieldTypesInvalid", "A parameter passed as a field type is not a valid field type");
        }
        boolean isCompat = false;
        switch (leftType) {
            case 1: 
            case 8: {
                if (rightType != 1 && rightType != 8) break;
                isCompat = true;
                break;
            }
            case 4: {
                if (rightType != 4) break;
                isCompat = true;
                break;
            }
            case 2: {
                if (rightType != 2 && rightType != 32 && rightType != 64) break;
                isCompat = true;
                break;
            }
            case 32: 
            case 64: {
                if (rightType != 2 && rightType != 32 && rightType != 64) break;
                isCompat = true;
                break;
            }
            case 16: {
                if (rightType != 16 && rightType != 2) break;
                isCompat = true;
            }
        }
        return isCompat;
    }

    public Object clone() {
        try {
            StringBuffer buffer = new StringBuffer();
            this.toXML(buffer);
            return VWScenarioDefinition.read(buffer.toString());
        }
        catch (VWException ex) {
            throw new AssertionError((Object)ex.getLocalizedMessage());
        }
    }
}

